#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Data.SqlClient;

#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodAvailability : BaseTest 
	{
		private BOL.BloodAvailability _bloodAvailability;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
			
				this._bloodAvailability = new BOL.BloodAvailability();
				this._bloodAvailability.AddDivisionFilter(UnitTestConfig.TestDivisionCode);

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetBloodAvailabilityItems_Pass()
		{
			DataSet dsTest = DAL.BloodAvailability.GetBloodAvailabilityItems(_bloodAvailability.BuildFilterStatement());

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(24, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count >= 0 , "Rows.Count");

			DataTable dtTest = dsTest.Tables[0];
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), TABLES.VamcDivision.DivisionName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionCode), TABLES.VamcDivision.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodType.BloodTypeCode), TABLES.BloodType.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABOSortColumn), ARTIFICIAL.ABOSortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorCode), TABLES.RhFactor.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.RhSortColumn), ARTIFICIAL.RhSortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.UnitStatusSortColumn), ARTIFICIAL.UnitStatusSortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.DirectedPatientLastName), ARTIFICIAL.DirectedPatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.DirectedPatientFirstName), ARTIFICIAL.DirectedPatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.DirectedPatientMiddleName), ARTIFICIAL.DirectedPatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingStatus.TestingStatusText), TABLES.TestingStatus.TestingStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), TABLES.IssuedUnit.IssueToLocationName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ComponentClassSortColumn), ARTIFICIAL.ComponentClassSortColumn);

		}

		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityItems_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityItems(string.Empty);
		}

		[Test]
		public void GetBloodAvailabilityAntigens_Pass()
		{
			DataSet dsTest = DAL.BloodAvailability.GetBloodAvailabilityAntigens(_bloodAvailability.BuildFilterStatement());

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(2, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count >= 0, "Rows.Count");
			
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityAntigens_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityAntigens(string.Empty);
		}

		[Test]
		public void GetBloodAvailabilityComments_Pass()
		{
			DataSet dsTest = DAL.BloodAvailability.GetBloodAvailabilityComments(_bloodAvailability.BuildFilterStatement());

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(2, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count >= 0, "Rows.Count");

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityComments_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityComments(string.Empty);
		}

		[Test]
		public void GetBloodAvailabilityTestComments_Pass()
		{
			DataSet dsTest = DAL.BloodAvailability.GetBloodAvailabilityTestComments(_bloodAvailability.BuildFilterStatement());

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(2, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count >= 0, "Rows.Count");

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityTestComments_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityTestComments(string.Empty);
		}

		[Test]
		public void GetBloodAvailabilityCount_Pass()
		{
			int count = DAL.BloodAvailability.GetBloodAvailabilityCount(_bloodAvailability.BuildFilterStatement());
			Assert.AreEqual(true, count >= 0, "Count");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityCount_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityCount(string.Empty);
		}

		[Test]
		public void GetBloodAvailabilityPatientCount_Pass()
		{
			Guid patientGuid = (Guid)(UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 PatientGuid FROM Patient")[TABLES.Patient.PatientGuid]);
			int count = DAL.BloodAvailability.GetBloodAvailabilityPatientCount(patientGuid);
			Assert.AreEqual(true, count >= 0, "Count");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentNullException))]
		public void GetBloodAvailabilityPatientCount_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityPatientCount(Guid.Empty);
		}

		[Test]
		public void GetBloodAvailabilityTestResults_Pass()
		{
			DataSet dsTest = DAL.BloodAvailability.GetBloodAvailabilityTestResults(_bloodAvailability.BuildFilterStatement());

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(3, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
		}
		
		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityTestResults_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityTestResults(string.Empty);
		}

		[Test]
		public void GetBloodAvailabilityAssignedPatients_Pass()
		{
			DataSet dsTest = DAL.BloodAvailability.GetBloodAvailabilityAssignedPatients(_bloodAvailability.BuildFilterStatement());

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(6, dsTest.Tables[0].Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
		}
		
		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityAssignedPatients_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityAssignedPatients(string.Empty);
		}

		[Test]
		public void GetBloodAvailabilityTargetUnits_Pass()
		{
			DataSet dsTest = DAL.BloodAvailability.GetBloodAvailabilityTargetUnits(_bloodAvailability.BuildFilterStatement());

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(3, dsTest.Tables[0].Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
		}
		
		[Test]
		[ExpectedExceptionAttribute(typeof(SqlException))]
		public void GetBloodAvailabilityTargetUnits_Fail()
		{
			DAL.BloodAvailability.GetBloodAvailabilityTargetUnits(string.Empty);
		}



	}
}
#endif


